/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

#define M_PI 3.141592653589793
#define M_2PI 6.283185307179586

void main(void)
{
	vec2 p = 2.0*(0.5 * iResolution.xy - gl_FragCoord.xy) / iResolution.xx;
	float angle = atan(p.y, p.x);
	float turn = (angle + M_PI) / M_2PI;
	float radius = sqrt(p.x*p.x + p.y*p.y);

	float n = 9.0;
	float angle_offset = 5.1*sin(0.3*iGlobalTime);
	float k_amplitude = 0.9*cos(1.2*iGlobalTime);
	float radius2 = radius + pow(radius, 2.0)*k_amplitude*sin(n*angle + angle_offset);
	float width = 0.05;
	float k_t = -0.04;
	
	float n_inv = 1.0 / float(n);
	vec3 color;
	float modulus = mod(float(int((radius2 + k_t*iGlobalTime) / width)), 3.0);
	if(modulus < 1.0) {
		//color = vec3(0.5, 0.0, 0.8);
		color = vec3(0.0, 0.4, 0.3);
	} else if(modulus < 2.0) {
		color = vec3(0.9, 0.0, 0.1);
	} else {
		color = vec3(0.5, 0.3, 0.0);
	}
	color /= 0.2 + pow(radius, 2.0);
	
	gl_FragColor = vec4(color, 1.0);
}